



<html>
<head>
  <title>javabog.dk - Webprogrammering med Java Server Pages - Introduktion</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel0.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel2.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">1 <a name='afsn1'></a>Introduktion</H1>
<DIV ID="Indholdsfortegnelse2">
  <P STYLE="margin-top: 0.5cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>1.1
  Hvad er HTML?  18</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>1.2
  Hvad er JSP?  19</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.2.1
  Princippet i serverside-teknologier  19</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>1.3
  Udviklingsv&aelig;rkt&oslash;jer til JSP  20</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.3.1
  Oracle JDeveloper  20</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.3.2
  Netbeans og Sun Java Studio Creator  21</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.3.3
  Borland JBuilder  21</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.3.4
  Eclipse og IBM WebSphere Studio  22</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>1.4
  Installation af en server  23</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.4.1
  Tomcat  23</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.4.2
  Resin  25</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>1.5
  PHP og ASP - JSPs f&aelig;tre  25</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">1.5.1
  JSP fremfor PHP og ASP - fordele og ulemper  26</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>1.6
  Videre l&aelig;sning  26</B></FONT></FONT></P>
</DIV>















<P CLASS="kapiteloversigt-western">En overfladisk forst&aring;else af
dette kapitel foruds&aelig;ttes i det meste af bogen.</P>
<P CLASS="western" STYLE="">Java Server
Pages (forkortet JSP) giver dig en lang r&aelig;kke af muligheder for
at g&oslash;re din hjemmeside mere levende.</P>
<P CLASS="western">JSP benyttes i mange sammenh&aelig;nge, hvor man
&oslash;nsker dynamiske indhold i HTML-sider, bl.a. i <SPAN LANG="da-DK">debatfora</SPAN>,
postlister, afstemninger og e-handels-l&oslash;sninger. 
</P>
<P CLASS="western">M&aring;let med denne bog er, at give en grundig
indf&oslash;rsel i, hvordan du kommer <SPAN LANG="da-DK">i gang</SPAN>
med at bruge JSP. Den starter fra bunden, men kr&aelig;ver dog, at du
i forvejen har et godt kendskab til HTML. JSP er mere avanceret end
HTML og det er en stor fordel hvis du allerede har pr&oslash;vet at
programmere i Java (eller et sprog med samme syntaks, f.eks.
<SPAN LANG="da-DK">JavaScript</SPAN> eller C/C++), da man kan bruge
Java som programmeringssprog i JSP. <SPAN LANG="da-DK">Databasekendskab</SPAN>
er ogs&aring; en fordel, da man ofte har brug for at gemme nogle
oplysninger.</P>
<P CLASS="western">Hvis du undervejs f&aring;r brug for hj&aelig;lp
kan du bes&oslash;ge nogle af henvisningerne i <a href='kapitel1.jsp#afsn1.6'>afsnit 1.6</a>. Der finder
du svar p&aring; sp&oslash;rgsm&aring;l lige fra helt banale
begynderproblemer til de meget avancerede sp&oslash;rgsm&aring;l.</P>
<H2 CLASS="western">1.1 <a name='afsn1.1'></a>Hvad er HTML?</SPAN></H2>
<P CLASS="western">Hjemmesider er skrevet i sproget HTML (<SPAN LANG="da-DK">HyperText</SPAN>
<SPAN LANG="da-DK">Markup</SPAN> Language). Det foruds&aelig;ttes at
du har rimeligt kendskab til HTML i forvejen, s&aring; hvis
nedenst&aring;ende kommer som en overraskelse for dig, b&oslash;r du
nok starte med en HTML-vejledning i stedet.</P>
<P CLASS="western"><IMG SRC="bog2_html_m73f3ffb5.png" NAME="Grafik59" ALIGN=RIGHT BORDER=0>Her
er et eksempel p&aring; en HTML-side:</P>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;<B>Simpel hjemmeside</B>&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;

&lt;h1&gt;<B>En simpel hjemmeside</B>&lt;/h1&gt;

&lt;p&gt;<B>Velkommen til min lille </B><SPAN STYLE="font-weight: medium">&lt;i&gt;</SPAN><B>hjemmeside</B><SPAN STYLE="font-weight: medium">&lt;/i&gt;</SPAN><B>.</B>
&lt;/p&gt;

&lt;p&gt;<B>Jeg hedder </B><SPAN STYLE="font-weight: medium">&lt;b&gt;</SPAN><B>Jacob</B><SPAN STYLE="font-weight: medium">&lt;/b&gt;</SPAN><B> og underviser p&aring;</B>
&lt;a href=&quot;http://<SPAN LANG="da-DK">www.cv.ihk.dk</SPAN>&quot;&gt;
<B>Center for Videreuddannelse</B>&lt;/a&gt; <B>p&aring;</B>
&lt;a href=&quot;http://<SPAN LANG="da-DK">ihk.dk</SPAN>&quot;&gt;
<B>Ingeni&oslash;rh&oslash;jskolen i K&oslash;benhavn</B>&lt;/a&gt;.
&lt;/p&gt;

&lt;p&gt;<B>Her kan du se hvordan jeg ser ud:</B>&lt;br&gt;
&lt;img src=&quot;jacob.jpg&quot;&gt;&lt;/p&gt;

&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
Til h&oslash;jre ses hvordan en netl&aelig;ser (eng.: web browser),
her Konqueror under Linux, viser siden. Det, der ikke er indkapslet i
&lt; og &gt; er tekst, der bliver vist p&aring; sk&aelig;rmen. 
</P>
<P CLASS="western">Koderne mellem &lt; og &gt; kaldes HTML-koder
(eng.: tags) og fort&aelig;ller netl&aelig;seren hvordan den skal
vise teksten. Eksempelvis markerer &lt;h1&gt; at der kommer en
overskrift, der skal vises med st&oslash;rre skrift end resten. 
</P>
<P CLASS="western">De fleste koder skal afsluttes med en slut-kode
(f.eks skal &lt;h1&gt; afsluttes med &lt;/h1&gt;). Koderne kan have
attributter, der giver ekstra information (f.eks har koden &lt;img&gt;,
der bruges til at vise et billede, attributten src, der angiver
filnavnet p&aring; billedet, der skal vises det p&aring;g&aelig;ldende
sted: &lt;img src=&quot;jacob.jpg&quot;&gt;).</P>
<H2 CLASS="western">1.2 <a name='afsn1.2'></a>Hvad er JSP?</SPAN></H2>
<P CLASS="western">En JSP-side er en en HTML-side med endelsen <STRONG CLASS="western"><SPAN LANG="da-DK">.jsp</SPAN></STRONG>,
som udover HTML ogs&aring; indeholder noget programkode, der er
skrevet i Java. <SPAN LANG="da-DK">Javakoden</SPAN> afvikles p&aring;
webserveren, og resultatet sendes til klienten, dvs. brugerens
netl&aelig;ser (eng.: web browser).</P>
<P CLASS="western">JSP (Java Server Pages) er udviklet af Sun
Microsystems og f&aelig;llesskabet omkring Java.</P>
<H3 CLASS="western">1.2.1 <a name='afsn1.2.1'></a>Princippet i serverside-teknologier</H3>
<P CLASS="western">Den bedste m&aring;de at forklare, hvordan en
serverside-teknologi (og dermed JSP) fungerer p&aring; er at
sammenligne det med almindelig HTML. 
</P>
<H4 CLASS="western">En HTML-side</H4>
<P CLASS="western">Forestil dig at du i din netl&aelig;sers
adresselinje taster adressen (URL<SPAN LANG="da-DK"><A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A></SPAN>)
p&aring; et HTML-dokument, f.eks. http://<SPAN LANG="da-DK">minesider.dk</SPAN>/<SPAN LANG="da-DK">dokument<B>.html</B></SPAN>.
Det kaldes at <I>anmode</I> (eng.: request) om en HTML-side. Da sker
der det f&oslash;lgende:</P>
<UL>
  <LI><P CLASS="western">Serveren finder HTML-filen</P>
  <LI><P CLASS="western">Serveren sender filen til klienten</P>
</UL>
<P CLASS="western">Serveren sender alts&aring; bare HTML-filen <SPAN LANG="da-DK">afsted</SPAN>
til klienten. 
</P>
<H4 CLASS="western">En JSP-side</H4>
<P CLASS="western">Hvis du <SPAN LANG="da-DK">i stedet</SPAN> taster
en URL p&aring; en JSP-side, f.eks. http://minesider.dk/<SPAN LANG="da-DK">dokument<B>.jsp</B></SPAN>,
og dermed anmoder om et JSP-dokument, kommer serveren p&aring;
arbejde:</P>
<UL>
  <LI><P CLASS="western">Serveren finder JSP-filen</P>
  <LI><P CLASS="western">Serveren kigger filen igennem for Java-kode</P>
  <LI><P CLASS="western">Serveren udf&oslash;rer de beregninger,
  Java-koden foreskriver</P>
  <LI><P CLASS="western">Serveren sender resultatet til klienten</P>
</UL>

<P CLASS="western">Det er vigtigt at forst&aring; at klienten kun ser
<I>resultatet</I> af serverens beregninger - ikke selve instrukserne.
JSP stiller derfor ikke krav til hvilken netl&aelig;ser dine
bes&oslash;gende har, men til serveren som dine sider ligger p&aring;.</P>
<P CLASS="western">Hvis du v&aelig;lger &quot;vis kilde&quot; (eng.:
View <SPAN LANG="da-DK">Source</SPAN>) n&aring;r du anmoder om at se
et JSP-dokument, kan du ikke se JSP-koderne - kun almindeligt HTML.
Du kan alts&aring; ikke se, hvordan en JSP-side er lavet, men er n&oslash;dt
til at l&aelig;re JSP p&aring; andre m&aring;der - f.eks. ved at l&aelig;se
denne bog.</P>
<P CLASS="western">Denne bog handler om at skrive kode, der udf&oslash;res
p&aring; serveren, og det betyder at du skal installere et program p&aring;
din computer, som g&oslash;r den i stand til at fungere som en
server. Der er naturligvis ogs&aring; den mulighed, at du bruger en
eksisterende server, der underst&oslash;tter JSP(f.eks. et <SPAN LANG="da-DK">webhotel)</SPAN>,
og at du s&aring; l&aelig;gger dine sider der, n&aring;r du vil pr&oslash;ve
dem.</P>

<H2 CLASS="western" STYLE="">1.3 <a name='afsn1.3'></a>Udviklingsv&aelig;rkt&oslash;jer
til JSP</SPAN></H2>
<P CLASS="western">Det antages at du allerede har et
redigeringsv&aelig;rkt&oslash;j til HTML og ved hvordan det bruges.</P>
<P CLASS="western">Desuden har du brug for adgang til en PC eller en
webserver, som kan afvikle JSP. 
</P>
<P CLASS="western">Den mest <SPAN LANG="da-DK">skrabede</SPAN>
l&oslash;sning, man kan v&aelig;lge at redigere JSP-siderne i, er et
ikke-Java-orienteret program, som for <SPAN STYLE="font-weight: medium">eksempel</SPAN>
Notesblok under Windows eller <SPAN LANG="da-DK">kedit</SPAN> (eller
emacs) under Linux. S&aring; er det n&oslash;dvendigt at installere
en server, som kan afvikle JSP (se <a href='kapitel1.jsp#afsn1.4'>afsnit 1.4</a>).</P>
<P CLASS="western">N&aring;r man programmerer synes de fleste dog, at
det er <SPAN LANG="da-DK">rarere</SPAN> at benytte et
Java-udviklingsmilj&oslash;, der kan hj&aelig;lpe en med:</P>
<UL>
  <LI><P CLASS="western">Redigering af kildetekster (skrevet i HTML,
  JSP og Java).</P>
  <LI><P CLASS="western">Overs&aelig;ttelse af kildeteksten og tjek
  for om den er syntaktisk korrekt.</P>
  <LI><P CLASS="western">Nem k&oslash;rsel og fejlfinding (i
  udviklingsmilj&oslash;ets indbyggede webserver).</P>
</UL>
<P CLASS="western">De fleste udviklingv&aelig;rkt&oslash;jer er
opbygget med en menulinje &oslash;verst, der indeholder tilgang til
filh&aring;ndtering, projektstyring og alle n&oslash;dvendige
v&aelig;rkt&oslash;jer, hvoraf den vigtigste er &quot;Run&quot;.
&quot;Run&quot; overs&aelig;tter f&oslash;rst kildeteksten og starter
derefter fortolkeren. Uddata kan ses i den nederste ramme. &quot;Debug&quot;
(der findes under &quot;Run&quot;) bruges til fejlfinding af
programmer og giver mulighed for at udf&oslash;re programkoden
<SPAN LANG="da-DK">trinvist.</SPAN></P>
<H3 CLASS="western">1.3.1 <a name='afsn1.3.1'></a>Oracle JDeveloper</H3>
<P CLASS="western">Databaseproducenten Oracle udgiver
udviklingsv&aelig;rkt&oslash;jet JDeveloper:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog2_html_m7bbbcf18.png" NAME="Grafik23" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western">JDeveloper kan en masse meget avancerede ting, men
kan for begyndere v&aelig;re indviklet at bruge, p&aring; grund af de
mange muligheder. 
</P>
<P CLASS="western">JDeveloper er skrevet i Java, kr&aelig;ver 256 MB
RAM og f&aring;s bl.a. til Windows og Linux. 
</P>
<P CLASS="western">Den fulde udgave kan hentes gratis til privat- og
undervisningsbrug p&aring; <A CLASS="western" HREF="http://oracle.com/">http://<SPAN LANG="da-DK">oracle.com</SPAN></A><SPAN LANG="da-DK">.</SPAN>
Til kommercielt brug skal man k&oslash;be en licens.</P>
<H3 CLASS="western">1.3.2 <a name='afsn1.3.2'></a>Netbeans og Sun Java Studio Creator</H3>
<P CLASS="western">Sun har udgivet sit eget udviklingsmilj&oslash;,
Sun Java Studio Creator (tidligere kaldet Forte og Sun ONE Studio),
ogs&aring; skrevet i Java, til Windows, Linux og Sun Solaris. 
</P>
<P CLASS="western"><IMG SRC="bog2_html_m5fbd22ab.png" NAME="Grafik24" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western">Udviklingsv&aelig;rkt&oslash;jet underst&oslash;tter
udvikling af JSP (s&oslash;rg for at have alle web-moduler
installeret):</P>
<P CLASS="western">V&aelig;lg f&oslash;rst File|<SPAN LANG="da-DK">New...</SPAN>|JSP
&amp; <SPAN LANG="da-DK">Servlets</SPAN>|Web <SPAN LANG="da-DK">Module</SPAN>
og v&aelig;lg en mappe du vil have dine JSP-filer, og derefter
File|New...|JSP &amp; Servlets|JSP og v&aelig;lg mappen du lige har
oprettet og giv et filnavn til JSP-siden (uden .jsp-endelse, det g&oslash;r
v&aelig;rkt&oslash;jet selv). H&oslash;jreklik p&aring; filen og v&aelig;lg
'<SPAN LANG="da-DK">Execute</SPAN>' for at k&oslash;re JSP-filen i
v&aelig;rkt&oslash;jets interne webserver.</P>
<P CLASS="western">En basisudgave af programmet har f&aring;et &Aring;ben
Kildekode (<SPAN LANG="da-DK">Open</SPAN> Source) under navnet
NetBeans og kan hentes gratis p&aring; <A CLASS="western" HREF="http://netbeans.org/">http://<SPAN LANG="da-DK">netbeans.org</SPAN></A><SPAN LANG="da-DK">.</SPAN>
En pr&oslash;veudgave af Sun Java Studio Creator kan hentes gratis p&aring;
http://developers.sun.com/prodtech/javatools/jscreator/</P>
<H3 CLASS="western">1.3.3 <a name='afsn1.3.3'></a>Borland JBuilder</H3>
<P CLASS="western">JBuilder fra Borland er et af de mest popul&aelig;re
Java-udviklingsmilj&oslash;er. JBuilder er skrevet i Java og k&oslash;rer
p&aring; b&aring;de <SPAN LANG="da-DK">Macintosh</SPAN>, Windows,
Linux og Sun Solaris. Det anbefales at have 256 MB RAM.</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog2_html_m759f5062.png" NAME="Grafik25" ALIGN=BOTTOM BORDER=0></P>

<P CLASS="western">En <SPAN LANG="da-DK">basisversion</SPAN> af
JBuilder, der desv&aelig;rre ikke tillader udvikling i JSP, kan
hentes gratis fra <A CLASS="western" HREF="http://borland.com/jbuilder">http://<SPAN LANG="da-DK">borland.com</SPAN>/<SPAN LANG="da-DK">jbuilder</SPAN></A><SPAN LANG="da-DK">.</SPAN>
&Oslash;nsker man adgang til de mere avancerede funktioner, herunder
udvikling i JSP, skal programmet k&oslash;bes eller man m&aring;
n&oslash;jes med en pr&oslash;veversion, der kun virker i 30 dage.</P>

<H3 CLASS="western">1.3.4 <a name='afsn1.3.4'></a>Eclipse og IBM WebSphere Studio</H3>
<P CLASS="western">IBM WebSphere Studio - baseret p&aring; Open
Source-initiativet Eclipse (<A CLASS="western" HREF="http://eclipse.org/">http://eclipse.org</A>)
er et andet st&aelig;rkt udviklingsmilj&oslash; til bl.a. JSP. En
gratis pr&oslash;veversion kan hentes p&aring; IBMs hjemmeside:
<A CLASS="western" HREF="http://www-306.ibm.com/software/awdtools/studioappdev/">http://www-306.ibm.com/software/awdtools/studioappdev/</A>.</P>

<H2 CLASS="western" STYLE="">1.4 <a name='afsn1.4'></a>Installation
af en server</SPAN></H2>
<P CLASS="western">De fleste udviklingsv&aelig;rkt&oslash;jer
underst&oslash;tter udvikling af JSP-sider og har en server
indbygget. 
</P>
<BLOCKQUOTE CLASS="definition-western"><SPAN LANG="da-DK">Har du et
Java-udviklingsmilj&oslash; der underst&oslash;tter webprogrammering
beh&oslash;ver du <I>ikke</I> installere en server for at pr&oslash;ve
at programmere JSP-sider</SPAN></BLOCKQUOTE>
<P CLASS="western">Er du begynder foretr&aelig;kker du sandsynligvis
at lade udviklingsmilj&oslash;et tage sig af detaljerne og bruge dens
server.</P>
<P CLASS="western">Vil du installere din egen server skal du have et
Java-<SPAN LANG="da-DK">udviklingskit</SPAN> (kaldet JDK eller J2SE)
installeret p&aring; din maskine. Java kan hentes fra
<A CLASS="western" HREF="http://java.sun.com/">http://java.sun.com</A>,
men har du allerede et Java-relateret udviklingsmilj&oslash; (f.eks
JBuilder, JDeveloper, <SPAN LANG="da-DK">Netbeans</SPAN>/Forte, ...)
p&aring; din maskine, er Java allerede installeret<A CLASS="sdfootnoteanc" NAME="sdfootnote2anc" HREF="#sdfootnote2sym"><SUP>2</SUP></A>.</P>
<P CLASS="western">Er du i tvivl kan det sj&aelig;ldent skade at
installere Java en gang til :-)</P>
<P CLASS="western">Der findes rigtig mange Java-webservere p&aring;
markedet, lige fra helt sm&aring; (endda en, der kun fylder 2
megabyte) til k&aelig;mpeprogrammer fra store firmaer som <SPAN LANG="da-DK">Borland,
Oracle og IBM:</SPAN></P>
<UL>
  <LI><P CLASS="western">Apache Tomcat -
  <A CLASS="western" HREF="http://jakarta.apache.org/tomcat/">http://jakarta.apache.org/tomcat/</A></P>
  <LI><P CLASS="western">Resin - <A CLASS="western" HREF="http://www.caucho.com/">http://www.caucho.com/</A></P>
  <LI><P CLASS="western">IBM Websphere -
  <A CLASS="western" HREF="http://www-4.ibm.com/software/webservers/">http://www-4.ibm.com/software/webservers/</A></P>
  <LI><P CLASS="western">Oracle Application Server -
  <A CLASS="western" HREF="http://www.oracle.com/appserver/java_edition.html">http://www.oracle.com/appserver/java_edition.html</A></P>
  <LI><P CLASS="western">BEA WebLogic -
  http://www.bea.com/products/weblogic/ 
  </P>
  <LI><P CLASS="western">Borland Enterprise AppServer -
  <A CLASS="western" HREF="http://www.borland.com/besappserver/">http://www.borland.com/besappserver/</A></P>
  <LI><P CLASS="western">Macromedia JRun -
  <A CLASS="western" HREF="http://www.macromedia.com/software/jrun/">http://www.macromedia.com/software/jrun/</A></P>
  <LI><P CLASS="western">Orion Application Server -
  <A CLASS="western" HREF="http://www.orionserver.com/">http://www.orionserver.com/</A></P>
  <LI><P CLASS="western">Jetty - <A CLASS="western" HREF="http://jetty.mortbay.com/jetty/">http://jetty.mortbay.com/jetty/</A></P>
  <LI><P CLASS="western">Blazix Java Application Server -
  http://www.blazix.com/ 
  </P>
</UL>
<P CLASS="western">Kun de f&oslash;rste to vil blive beskrevet i det
f&oslash;lgende.</P>
<H3 CLASS="western">1.4.1 <a name='afsn1.4.1'></a>Tomcat</H3>
<P CLASS="western">Jakarta Tomcat (<A CLASS="western" HREF="http://jakarta.apache.org/tomcat/">http://jakarta.apache.org/tomcat/</A>)
er <SPAN LANG="da-DK">Suns</SPAN> officielle implementering af en
JSP-server. Den har for <SPAN LANG="da-DK">programudviklere</SPAN> en
speciel status som reference-implementering, s&aring;dan at den, i
tvivlstilf&aelig;lde, definerer hvordan en JSP-webserver b&oslash;r
fungere, og viser dermed de andre producenter af JSP-servere, hvad de
har at rette sig efter.</P>
<P CLASS="western">Tomcat har &Aring;ben Kildekode (eng.: Open
Source) og er gratis at bruge b&aring;de til ikke-kommercielle og
kommercielle form&aring;l.</P>
<P CLASS="western">Den kan hentes p&aring; adressen
<A CLASS="western" HREF="http://jakarta.apache.org/builds/jakarta-tomcat/">http://jakarta.apache.org/<SPAN LANG="da-DK">builds</SPAN>/jakarta-tomcat/</A>.
Hjemmesiden er lidt sv&aelig;r at finde rundt i, men du skal ende med
at st&aring; med en fil der hedder f.eks. jakarta-tomcat-5.0.27.exe
(installationsprogram - anbefales hvis du bruger Windows) eller
jakarta-tomcat-5.0.27.zip (kan bruges under b&aring;de Linux, Windows
og andre styresystemer).</P>
<P CLASS="western"><SPAN LANG="da-DK">Versionsnummeret</SPAN> kan
selvf&oslash;lgelig variere, men til de ting du kommer til at bruge
her g&oslash;r det ikke den store forskel hvilken version du bruger.</P>
<P CLASS="western">Bruger du ZIP-filen er der et par skridt du skal
ordne selv:</P>
<H4 CLASS="western">Installation af ZIP-filen - Linux</H4>
<P CLASS="western">Pak ZIP-filen med Tomcat ud, f.eks. i din
<SPAN LANG="da-DK">hjemmemappe</SPAN> og g&aring; ind i <SPAN LANG="da-DK">bin</SPAN>-mappen:</P>
<PRE CLASS="kode-western">cd jakarta-tomcat-5.0.27/bin</PRE><P CLASS="western">
<SPAN LANG="da-DK">Milj&oslash;variablen</SPAN> JAVA_HOME skal v&aelig;re
sat til at pege p&aring; din Java-installation.</P>
<P CLASS="western">Det kan du g&oslash;re ved at skrive (erstat stien
med der, hvor Java er installeret)</P>
<PRE CLASS="kode-western"><SPAN LANG="da-DK">export</SPAN> JAVA_HOME=/<SPAN LANG="da-DK">usr</SPAN>/local/jdk1.4</PRE><P CLASS="western">
p&aring; kommandolinjen eller ved at redigere filen catalina.sh eller
setclasspath.sh og inds&aelig;tte linjen &oslash;verst. S&oslash;rg
ogs&aring; for at alt i bin-mappen kan eksekveres (chmod a+x *).</P>
<P CLASS="western">Start derefter Tomcat:</P>
<PRE CLASS="kode-western">./startup.sh</PRE><H4 CLASS="western">
Installation af ZIP-filen - Windows</H4>
<P CLASS="western">Pak ZIP-filen med Tomcat ud, f.eks. i C:\ (roden
p&aring; C-drevet). Derefter skal du ind i kontrolpanelet og definere
<SPAN LANG="da-DK">milj&oslash;variablen </SPAN>JAVA_HOME til at pege
p&aring; der, hvor JDK er installeret (f.eks. C:\JBuilderX\jdk1.4).
Du kan ogs&aring; g&aring; ind i <SPAN LANG="da-DK">Tomcats</SPAN>
bin-mappe og redigere filen <SPAN LANG="da-DK">catalina.bat</SPAN>
eller <SPAN LANG="da-DK">setclasspath.bat</SPAN> og s&aelig;tte
linjen</P>
<PRE CLASS="kode-western">set JAVA_HOME=C:\JBuilderX\jdk1.4</PRE><P CLASS="western">
ind &oslash;verst i filen (erstat stien med der, hvor Java er
installeret). Det kan v&aelig;re du ogs&aring; skal h&oslash;jreklikke
p&aring; <SPAN LANG="da-DK">startup.bat</SPAN> og under Egenskaber
v&aelig;lge at reservere mere hukommelse til milj&oslash;variabler.</P>
<P CLASS="western">Start derefter Tomcat, ved at <SPAN LANG="da-DK">dobbeltklikke</SPAN>
p&aring; startup.bat.</P>
<H4 CLASS="western"><IMG SRC="bog2_html_m32d39574.png" NAME="Grafik50" ALIGN=RIGHT HSPACE=2 BORDER=0>Pr&oslash;ve
installationen</H4>
<P CLASS="western">Du kan nu g&aring; i gang med at lege med Tomcat
og pr&oslash;ve JSP-eksemplerne, der f&oslash;lger med Tomcat. Det er
ogs&aring; en god id&eacute; at udforske filstrukturen (med f.eks.
Stifinder) og blive fortrolig med mappestrukturen (vist til h&oslash;jre).
</P>
<P CLASS="western">Tjek f&oslash;rst at Tomcat k&oslash;rer ved at
&aring;bne <A CLASS="western" HREF="http://localhost:8080/">http://localhost:8080/</A>.
G&oslash;r den ikke det, m&aring; du l&aelig;se
installationsvejledningen der f&oslash;lger med Tomcat n&oslash;jere
og evt. kigge p&aring; log-filerne (der ligger i undermappen <SPAN LANG="da-DK">logs/</SPAN>).</P>
<P CLASS="western">Websiderne er opdelt i grupper, der kaldes
webapplikationer. Hver webapplikation ligger under dens eget navn i
en mappe under webapps/.</P>
<P CLASS="western">F.eks. ligger JSP-eksemplerne under
webapps/<B>jsp-examples</B>/ p&aring; filsystemet og kan tilsvarende
findes i gennem webserveren p&aring; adressen
<A CLASS="western" HREF="http://localhost:8080/jsp-examples/">http://localhost:8080/<B>jsp-examples</B>/</A>.
 
</P>
<P CLASS="western">Webapplikationer forklares n&aelig;rmere i <a href='kapitel7.jsp#afsn7.4'>afsnit
7.4</a>.</P>

<H4 CLASS="western">Hvis du har problemer med at se JSP-sider</H4>
<P CLASS="western">Hvis JSP-eksemplerne ikke virker (men du i &oslash;vrigt
godt kan se almindelige HTML-sider og servletter gennem din Tomcat p&aring;
<A CLASS="western" HREF="http://localhost:8080/">http://localhost:8080/</A>)
s&aring; er det nok fordi Tomcat ikke kan finde filen <SPAN LANG="da-DK">tools.jar</SPAN>
(der findes i din Java-installation, sandsynligvis under
jdk1.4/lib/tools.jar). S&aring; f&aring;r du nok fejlen
&quot;<SPAN LANG="da-DK">java.lang.NoClassDefFoundError</SPAN>:
sun/<SPAN LANG="da-DK">tools</SPAN>/javac/<SPAN LANG="da-DK">Main</SPAN>&quot;,
n&aring;r du fors&oslash;ger at se en JSP-side.</P>
<P CLASS="western">S&oslash;rg da for, at Tomcat kender
jdk1.4/lib/tools.jar fra JDKet, f.eks. ved at indf&oslash;je den i
CLASSPATH eller kopiere den ind i <SPAN LANG="da-DK">ext</SPAN>/-mappen
for din JDK (jdk1.4/jre/lib/ext/). Se evt. <a href='kapitel4.jsp#afsn4.9.6'>afsnit 4.9.6</a>, Hvis klasse(bibliotek)er ikke kan findes.</P>
<P CLASS="western">Bem&aelig;rk at du skal have JDK (Java <SPAN LANG="da-DK">Developers</SPAN>
Kit, ogs&aring; kaldet J2SE - Java 2 Standard Edition) installeret.
JRE (Java <SPAN LANG="da-DK">Runtime</SPAN> <SPAN LANG="da-DK">Environment</SPAN>)
er ikke tilstr&aelig;kkeligt. 
</P>

<H3 CLASS="western">1.4.2 <a name='afsn1.4.2'></a>Resin</H3>
<P CLASS="western">En anden popul&aelig;r webserver er Resin fra
<SPAN LANG="da-DK">Caucho</SPAN> (<A CLASS="western" HREF="http://caucho.com/">http://caucho.com</A>).
Den er der mange der synes er betydeligt lettere at installere og
bruge end Tomcat.</P>
<P CLASS="western">Resin skal blot hentes fra <A CLASS="western" HREF="http://caucho.com/">http://caucho.com</A>
og pakkes ud, hvorefter <SPAN LANG="da-DK">httpd.exe</SPAN> (Windows)
eller <SPAN LANG="da-DK">httpd.sh</SPAN> (Linux), der ligger inde i
bin-mappen, startes.</P>
<P CLASS="western">Derefter kan man pr&oslash;ve den ved at &aring;bne
<A CLASS="western" HREF="http://localhost:8080/">http://localhost:8080/</A>,
klikke p&aring; Demo og pr&oslash;ve JSP-eksemplerne (de ligger som
filer i doc/examples/basic/).</P>
<P CLASS="western">Resin har &Aring;ben Kildekode og er gratis at
bruge til ikke-kommercielle form&aring;l. Til kommercielle form&aring;l
skal en licens k&oslash;bes.</P>
<P CLASS="western">Den rareste ting ved Resin i forhold til Tomcat
viser sig f&oslash;rst, n&aring;r man begynder at arbejde med
servletter og separate java-klasser: Resin overs&aelig;tter selv
automatisk .java-kildetekstfilerne til bin&aelig;re .class-filer og
indl&aelig;ser dem. I Tomcat skal man selv s&oslash;rge for at
overs&aelig;tte .java-kildetekst til .class-filer.</P>

<H2 CLASS="western">1.5 <a name='afsn1.5'></a>PHP og ASP - JSPs f&aelig;tre</SPAN></H2>
<P CLASS="western">JSP er, som vi vil se i n&aelig;ste kapitel,
HTML-sider med noget ekstra programkode, der udf&oslash;res p&aring;
serveren. Dette princip er ogs&aring; brugt i en r&aelig;kke andre
web-programmeringssprog, s&aring;som det ekstremt popul&aelig;re PHP
(der st&aring;r for PHP: Hypertext Preprocessor) og det mindre
popul&aelig;re ASP (Active Server Pages) fra Microsoft.</P>
<H3 CLASS="western" STYLE="">1.5.1 <a name='afsn1.5.1'></a>JSP
fremfor PHP og ASP - fordele og ulemper</H3>
<UL>
  <LI><P CLASS="western">Kender man allerede Java er JSP det nemmeste
  at g&aring; til.</P>
  <LI><P CLASS="western">Kender man ikke Java er JSP sv&aelig;rere at
  l&aelig;re end PHP eller ASP. JSP bruger de almindelige Java-klasser
  og f&oslash;lger Java-syntaksen, som bl.a. skelner mellem store og
  sm&aring; bogstaver, og det kan v&aelig;re sv&aelig;rt for
  begyndere. <BR>Man kan dog anvende JSTL i sine JSP-sider i stedet.
  JSTL (der er beskrevet i <a href='kapitel2.jsp#afsn2.1.5'>afsnit 2.1.5</a>) er et HTML-lignende sprog,
  der er betydeligt lettere at l&aelig;re end Java.</P>
  <LI><P CLASS="western">JSP (og Java) er <SPAN LANG="da-DK">platformsuafh&aelig;ngigt</SPAN>,
  s&aring; man kan frit v&aelig;lge om ens server skal k&oslash;re p&aring;
  Windows, Linux, <SPAN LANG="da-DK">Mac</SPAN> eller andre <SPAN LANG="da-DK">UNIX'er
  (PHP k&oslash;rer ogs&aring; n&aelig;sten alle platforme, </SPAN>mens
  ASP i praksis kun k&oslash;rer p&aring; Microsoft Windows).</P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Webapplikationer</SPAN>
  skrevet i JSP kan k&oslash;re p&aring; en r&aelig;kke forskellige
  webservere som f.eks. Apache Tomcat, BEA <SPAN LANG="da-DK">WebLogic</SPAN>,
  IBM WebSphere, Oracle Application Server, Resin og en snes andre.
  Popul&aelig;re webservere som Apache og IIS (Microsoft Internet
  Information Server) kan nemt udvides til at underst&oslash;tte JSP
  via et plugin.</P>
  <LI><P CLASS="western">JSP er ikke s&aring; udbredt til sm&aring;
  projekter som PHP eller ASP. Du vil sandsynligvis finde flere p&aring;
  nettet, der kan hj&aelig;lpe dig med disse sprog end med JSP. 
  </P>
  <LI><P CLASS="western">Der er ogs&aring; flere <SPAN LANG="da-DK">webhoteller</SPAN>,
  der underst&oslash;tter PHP eller ASP end JSP. Hvis du planl&aelig;gger
  at bruge et webhotel (i stedet for at installere din egen server)
  skal du lige tjekke, om du kan finde et der passer til dine behov og
  underst&oslash;tter JSP.</P>
  <LI><P CLASS="western">JSP er meget udbredt til st&oslash;rre
  projekter, som det er meget velegnet til. 
  </P>
  <LI><P CLASS="western">JSP er en <SPAN LANG="da-DK">velintegreret</SPAN>
  del af J2EE (Java 2 Enterprise Edition), som er et meget udbredt
  serversystem der findes bred underst&oslash;ttelse for i industrien.</P>
</UL>
<P CLASS="western">Som tommelfingerregel er det en god id&eacute; at
v&aelig;lge JSP hvis du kender Java i forvejen eller hvis du gerne
vil l&aelig;re et sprog og en metodik, der ogs&aring; fungerer sammen
med store serversystemer.</P>

<H2 CLASS="western">1.6 <a name='afsn1.6'></a>Videre l&aelig;sning</SPAN></H2>
<UL>
  <LI><P CLASS="western"><A CLASS="western" HREF="http://html.dk/">http://html.dk</A>
  har en glimrende introduktion til HTML og relaterede sprog som CSS
  (typografier i hjemmesiden - eng: Cascading Style Sheets) og
  JavaScript (kode der k&oslash;res i klientens netl&aelig;ser).</P>
</UL>
<P CLASS="western">Man kan l&aelig;se mere om JSP p&aring; de
f&oslash;lgende sider:</P>
<UL>
  <LI><P CLASS="western"><A CLASS="western" HREF="http://java.sun.com/products/jsp/technical.html">http://java.sun.com/products/jsp/<SPAN LANG="da-DK">technical.html</SPAN></A>
    </P>
  <LI><P CLASS="western"><A CLASS="western" HREF="http://jsptut.com/">http://<SPAN LANG="da-DK">jsptut.com</SPAN></A>
    </P>
</UL>
<P CLASS="western">Har du brug for hj&aelig;lp til JSP eller
installation af serverne s&aring; kig forbi</P>
<UL>
  <LI><P CLASS="western">Diskussionsgruppen <SPAN LANG="da-DK">dk.edb.programmering.java</SPAN>
  <BR>(kan findes p&aring;
  <A CLASS="western" HREF="http://groups.google.dk/groups?q=dk.edb.programmering.java">http://<SPAN LANG="da-DK">groups.google.dk</SPAN>/<SPAN LANG="da-DK">groups</SPAN>?q=dk.edb.programmering.java</A>)</P>
  <LI><P CLASS="western"><A CLASS="western" HREF="http://www.eksperten.dk/">http://<SPAN LANG="da-DK">www.eksperten.dk</SPAN></A></P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">P&aring;
  </SPAN><A CLASS="western" HREF="http://java.sun.com/products/jsp/jsp-asp.html"><SPAN LANG="da-DK">http://java.sun.com/products/jsp/jsp-asp.html</SPAN></A><SPAN LANG="da-DK">
  kan du se en sammenligning mellem JSP og ASP.</SPAN></P>
</UL>

<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>
  URL - Uniform Resource Locator - den adresse, som en hjemmeside har
  p&aring; internettet.</P>
</DIV>
<DIV ID="sdfootnote2">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>I
  det tilf&aelig;lde kan du bruge <SPAN LANG="da-DK">JDKet</SPAN> der
  f&oslash;lger med udviklingsmilj&oslash;et. I de fleste ligger JDKet
  i en mappe med navnet JDK, f.eks. ligger Borlans <SPAN LANG="da-DK">JBuilders</SPAN>
  JDK i mappen JBuilderX/jdk1.4/)</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel0.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel2.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b>Webprogrammering med Java Server Pages</b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (72% af vrket).
</font>
<br>
nsker du at se de sidste 28% af dette vrk (275315 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
